

<?php $__env->startSection('title', 'Detalle de Planilla'); ?>

<?php $__env->startSection('content'); ?>

<div class="container mt-4" style="max-width: 700px;">

    <h4 class="mb-4" style="color:#FCCB00;">Detalle de Planilla</h4>

    <div class="card shadow-sm mg-card">
        <div class="card-body">

            <h5 class="card-title mb-3" style="color:#FCCB00;">
                <?php echo e($planilla->empleado->user->name ?? 'Empleado'); ?>

            </h5>

            <ul class="list-group list-group-flush mb-3 mg-card" style="background:none;border:none;">
                <li class="list-group-item bg-transparent text-white border-secondary">
                    <strong>Mes:</strong>
                    <?php echo e(\Carbon\Carbon::parse($planilla->mes)->translatedFormat('F Y')); ?>

                </li>

                <li class="list-group-item bg-transparent text-white border-secondary">
                    <strong>Salario Base:</strong>
                    <?php echo e(number_format($planilla->salario_base, 2)); ?> Bs
                </li>

                <li class="list-group-item bg-transparent text-white border-secondary">
                    <strong>Días Trabajados:</strong> <?php echo e($planilla->dias_trabajados); ?>

                </li>

                <li class="list-group-item bg-transparent text-white border-secondary">
                    <strong>Faltas:</strong> <?php echo e($planilla->faltas); ?>

                </li>

                <li class="list-group-item bg-transparent text-white border-secondary">
                    <strong>Retrasos:</strong> <?php echo e($planilla->retrasos); ?>

                </li>

                <li class="list-group-item bg-transparent text-white border-secondary">
                    <strong>Horas Extra:</strong> <?php echo e($planilla->horas_extra); ?>

                </li>

                <li class="list-group-item bg-transparent text-white border-secondary">
                    <strong>Total Descuento:</strong>
                    <?php echo e(number_format($planilla->total_descuento, 2)); ?> Bs
                </li>

                <li class="list-group-item bg-transparent text-white border-secondary">
                    <strong>Total Bonificación:</strong>
                    <?php echo e(number_format($planilla->total_bonificacion, 2)); ?> Bs
                </li>

                <li class="list-group-item bg-transparent text-white border-secondary">
                    <strong>Salario Neto:</strong>
                    <span style="color:#FCCB00;font-weight:bold;">
                        <?php echo e(number_format($planilla->salario_neto, 2)); ?> Bs
                    </span>
                </li>

                <li class="list-group-item bg-transparent text-white border-secondary">
                    <strong>Estado:</strong> <?php echo e($planilla->estado); ?>

                </li>
            </ul>

            <h6 class="mt-4" style="color:#FCCB00;">Detalle de Descuentos:</h6>
            <p><?php echo e($planilla->detalle_descuento ?: '—'); ?></p>

            <h6 class="mt-3" style="color:#FCCB00;">Detalle de Bonificaciones:</h6>
            <p><?php echo e($planilla->detalle_bonificacion ?: '—'); ?></p>

            <div class="mt-4 text-end">
                <a href="<?php echo e(route('planillas.index')); ?>" class="btn btn-outline-secondary">Volver</a>
            </div>

        </div>
    </div>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/planillas/show.blade.php ENDPATH**/ ?>