

<?php $__env->startSection('title', 'Registrar Nuevo Empleado'); ?>

<?php $__env->startSection('content'); ?>

<div class="container d-flex justify-content-center">
    <div class="card shadow p-4 mg-card w-100" style="max-width: 700px;">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Registrar Nuevo Empleado</h5>
            <a href="<?php echo e(route('empleados.index')); ?>" class="btn btn-sm btn-outline-secondary">← Volver</a>
        </div>

        <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <form action="<?php echo e(route('empleados.store')); ?>" method="POST" enctype="multipart/form-data" class="mg-form">
            <?php echo csrf_field(); ?>

            
            <div class="mb-3">
                <label for="user_id" class="form-label">Usuario del Sistema</label>
                <select name="user_id" id="user_id" class="form-select" required>
                    <option value="">-- Selecciona un usuario --</option>
                    <?php $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>">
                        <?php echo e($user->nombres); ?> <?php echo e($user->apellido_paterno); ?> <?php echo e($user->apellido_materno); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            
            <div class="mb-3">
                <label for="foto" class="form-label">Foto del Empleado (opcional)</label>
                <input type="file" name="foto" id="foto" class="form-control" accept="image/*">
            </div>

            
            <div class="mb-3">
                <label for="edad" class="form-label">Edad</label>
                <input type="number" name="edad" id="edad" class="form-control" value="<?php echo e(old('edad')); ?>" required>
            </div>

            
            <div class="mb-3">
                <label for="ci" class="form-label">Cédula de Identidad</label>
                <input type="text" name="ci" id="ci" class="form-control" value="<?php echo e(old('ci')); ?>" required>
            </div>

            
            <div class="mb-3">
                <label for="codigo_visible" class="form-label">Código (autogenerado)</label>
                <input type="text" class="form-control" id="codigo_visible" value="<?php echo e($codigo); ?>" disabled>
                <input type="hidden" name="codigo" value="<?php echo e($codigo); ?>">
            </div>

            
            <div class="mb-3">
                <label for="celular" class="form-label">Número de Celular</label>
                <input type="text" name="celular" id="celular" class="form-control" value="<?php echo e(old('celular')); ?>" required>
            </div>

            
            <div class="mb-3">
                <label for="salario_mensual" class="form-label">Salario Mensual</label>
                <input type="number" name="salario_mensual" class="form-control" id="salario_mensual"
                    value="<?php echo e(old('salario_mensual', $empleado->salario_mensual ?? '')); ?>" step="0.01" required>
            </div>

            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="fecha_ingreso" class="form-label">Fecha de Ingreso</label>
                    <input type="date" name="fecha_ingreso" id="fecha_ingreso" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="fecha_retiro" class="form-label">Fecha de Retiro (opcional)</label>
                    <input type="date" name="fecha_retiro" id="fecha_retiro" class="form-control">
                </div>
            </div>

            
            <div class="mb-3">
                <label for="referencia_1_nombre" class="form-label">Nombre Completo Referencia Familiar 1</label>
                <input type="text" name="referencia_1_nombre" id="referencia_1_nombre" class="form-control" required>
            </div>

            <div class="mb-3">
                <label for="referencia_1_celular" class="form-label">Celular Referencia 1</label>
                <input type="text" name="referencia_1_celular" id="referencia_1_celular" class="form-control" required>
            </div>

            
            <div class="mb-3">
                <label for="referencia_2_nombre" class="form-label">Nombre Completo Referencia Familiar 2 (opcional)</label>
                <input type="text" name="referencia_2_nombre" id="referencia_2_nombre" class="form-control">
            </div>

            <div class="mb-3">
                <label for="referencia_2_celular" class="form-label">Celular Referencia 2 (opcional)</label>
                <input type="text" name="referencia_2_celular" id="referencia_2_celular" class="form-control">
            </div>

            
            <div class="mb-3">
                <label for="ubicacion_domicilio" class="form-label">Ubicación de Domicilio (enlace de Google Maps)</label>
                <input type="url" name="ubicacion_domicilio" id="ubicacion_domicilio" class="form-control"
                    placeholder="https://maps.app.goo.gl/..." value="<?php echo e(old('ubicacion_domicilio')); ?>" required>

                <small class="text-muted">
                    Desde tu celular: abre Google Maps → mantén presionado tu domicilio → presiona “Compartir” → “Copiar enlace” → pega aquí.
                </small>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary">Guardar Empleado</button>
            </div>

        </form>

    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/empleados/create.blade.php ENDPATH**/ ?>