

<?php $__env->startSection('title', 'Editar Horario'); ?>

<?php $__env->startSection('content'); ?>

<div class="container d-flex justify-content-center">
    <div class="card shadow p-4 mg-card w-100" style="max-width: 700px;">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Editar Horario</h5>
            <a href="<?php echo e(route('horarios.index')); ?>" class="btn btn-sm btn-outline-secondary">← Volver</a>
        </div>

        <form action="<?php echo e(route('horarios.update', $horario)); ?>" method="POST" class="mg-form">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-3">
                <label class="form-label">Empleado (opcional)</label>
                <select name="empleado_id" class="form-select">
                    <option value="">Horario general</option>

                    <?php $__currentLoopData = $empleados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empleado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($empleado->id); ?>"
                        <?php echo e($horario->empleado_id == $empleado->id ? 'selected' : ''); ?>>
                        <?php echo e($empleado->user->nombres ?? 'Sin nombre'); ?>

                        <?php echo e($empleado->user->apellido_paterno ?? ''); ?>

                        <?php echo e($empleado->user->apellido_materno ?? ''); ?>

                        (<?php echo e($empleado->ci); ?>)
                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </select>
            </div>

            <div class="mb-3">
                <label class="form-label">Hora de Entrada</label>
                <input type="time" name="hora_entrada" class="form-control"
                    value="<?php echo e($horario->hora_entrada); ?>" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Hora de Salida</label>
                <input type="time" name="hora_salida" class="form-control"
                    value="<?php echo e($horario->hora_salida); ?>" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Nombre del Turno (opcional)</label>
                <input type="text" name="nombre_turno" class="form-control"
                    value="<?php echo e($horario->nombre_turno); ?>">
            </div>

            <div class="d-flex justify-content-end gap-2">
                <button type="submit" class="btn btn-primary">Actualizar Horario</button>
                <a href="<?php echo e(route('horarios.index')); ?>" class="btn btn-outline-secondary">Cancelar</a>
            </div>

        </form>

    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/horarios/edit.blade.php ENDPATH**/ ?>