

<?php $__env->startSection('title', 'Planillas de Pago'); ?>

<?php $__env->startSection('content'); ?>

<div class="container mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0" style="color:#FCCB00;">Planillas Generadas</h4>
        <a href="<?php echo e(route('planillas.create')); ?>" class="btn btn-primary">+ Generar Planilla</a>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success text-center">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>

    <div class="table-responsive">
        <table class="table mg-table table-bordered table-hover align-middle text-center">
            <thead>
                <tr>
                    <th>Empleado</th>
                    <th>Mes</th>
                    <th>Salario Base</th>
                    <th>Descuento</th>
                    <th>Bonos</th>
                    <th>Salario Neto</th>
                    <th>Acción</th>
                </tr>
            </thead>

            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $planillas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planilla): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($planilla->empleado->user->name ?? '—'); ?></td>

                    <td><?php echo e(\Carbon\Carbon::parse($planilla->mes)->translatedFormat('F Y')); ?></td>

                    <td><?php echo e(number_format($planilla->salario_base, 2)); ?> Bs</td>
                    <td><?php echo e(number_format($planilla->total_descuento, 2)); ?> Bs</td>
                    <td><?php echo e(number_format($planilla->total_bonificacion, 2)); ?> Bs</td>

                    <td>
                        <strong><?php echo e(number_format($planilla->salario_neto, 2)); ?> Bs</strong>
                    </td>

                    <td>
                        <a href="<?php echo e(route('planillas.show', $planilla)); ?>"
                            class="btn btn-sm btn-outline-secondary">
                            Ver Detalle
                        </a>
                    </td>
                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted">No hay planillas generadas aún.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/planillas/index.blade.php ENDPATH**/ ?>