

<?php $__env->startSection('title', 'Usuarios'); ?>

<?php $__env->startSection('content'); ?>

<?php
$rol = auth()->user()->rol ?? null;
?>

<?php if($rol !== 'administrador'): ?>

<div class="container mt-5 text-center">
    <h3 class="text-danger">🚫 Acceso denegado</h3>
    <p>No tienes permiso para ver este módulo.</p>
    <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-primary mt-3">Volver al inicio</a>
</div>

<?php else: ?>

<div class="container d-flex justify-content-between align-items-center mb-4" style="max-width: 1000px;">
    <h4 class="mb-0" style="color:#FCCB00;">Lista de usuarios</h4>
    <a href="<?php echo e(route('usuarios.create')); ?>" class="btn btn-primary">+ Nuevo Usuario</a>
</div>

<?php if(session('success')): ?>
<div class="container" style="max-width: 1000px;">
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
</div>
<?php endif; ?>

<div class="container" style="max-width: 1000px;">
    <div class="table-responsive">
        <table class="table mg-table table-bordered table-hover align-middle text-center">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nombres</th>
                    <th>Apellido Paterno</th>
                    <th>Apellido Materno</th>
                    <th>Email</th>
                    <th>Rol</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>

            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($usuario->id); ?></td>
                    <td><?php echo e($usuario->nombres); ?></td>
                    <td><?php echo e($usuario->apellido_paterno); ?></td>
                    <td><?php echo e($usuario->apellido_materno); ?></td>
                    <td><?php echo e($usuario->email); ?></td>
                    <td><?php echo e(ucfirst($usuario->rol)); ?></td>

                    <td>
                        <?php if($usuario->estado === 'activo'): ?>
                        <span class="badge bg-success">Activo</span>
                        <?php else: ?>
                        <span class="badge bg-secondary">Inactivo</span>
                        <?php endif; ?>
                    </td>

                    <td>
                        <a href="<?php echo e(route('usuarios.edit', $usuario)); ?>" class="btn btn-sm btn-warning">Editar</a>
                        <form action="<?php echo e(route('usuarios.destroy', $usuario)); ?>" method="POST" style="display:inline;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('¿Deseas eliminar este usuario?')">Eliminar</button>
                        </form>
                    </td>
                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" class="text-center">No se encontraron usuarios.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/usuarios/index.blade.php ENDPATH**/ ?>